REM_Header START
*****************************************************************************
*
* Resource Editor Module Header
*
* Copyright, (c) 1991
* by Marc W. Wolfgram
* All Rights Reserved
*
* Marc W Wolfgram  4/ 2/91 20:15:08
*                  4/25/91  0:52:48     Added VidMode and fStacked entries.
*                 10/17/91 19:12:28     Added fWinProc and changed PrintPB.
*                 10/31/91 21:10:17     Added remHelpID long.
*                  7/11/92 22:26:57     Added fUserID/~USERID and ~TOOLERROR.
*                  7/14/92  2:53:51     fStack was fStacked
*                  7/20/92 22:15:29     added ORCA/Pascal callback glue.
*****************************************************************************
*
* The first 8 entries are vectors to handle calls from Foundation for a
* specific editor task.
*
           dc       i4'REM_Open-1'      begin editing, fOpenRec pb
           dc       i4'REM_Close-1'     close editing, fCloseRec pb
           dc       i4'REM_Write-1'     close editing, fCloseRec pb
           dc       i4'REM_Event-1'     event occured, fEventRec pb
           dc       i4'REM_Activate-1'  edit activate, fActivateRec pb
           dc       i4'REM_GetLink-1'   request child, fLinkRec pb
           dc       i4'REM_VidMode-1'   video changed, fCloseRec pb
           dc       i4'REM_Print-1'     request print, fOpenRec pb
*
* The next long is used by the REM to pass the resource ID of the current
* $8014 rText resource for the Foundation help system.
*
           case     on
REMHELPID  ENTRY
remHelpID  ENTRY
           case     off
           dc       i4'0'
*
* Offset +36 will contain the a pointer to the Foundation fWinProc.  This
* can be used by an editor to do live testing of the current file's resources.
* The drawproc, which is passed in the NewWindow2 tool call (ref: TBR 3), sets
* the current resource file to the file being edited and sets the current file
* depth to 1.  It then does a DrawControls for that window.
*
           case     on
FWINPROC   ENTRY
fWinProc   ENTRY
           case     off
           dc       i4'0'
*
* These 2 entries are vectors called when the REM is loaded or Foundation quits.
*
           dc       i4'REM_StartUp-1'   initialize it, fStartStopRec pb
           dc       i4'REM_ShutDown-1'  shut REM down, fStartStopRec pb
*
* Offset +48 will contain the Foundation inline callback.  This vector is set
* when the REM is first loaded.
* Calls to this vector are of the same format as the ProDOS inline vector.
*
*          jsl      FINLINE
*          dc       i2'Command'
*          dc       i4'ParameterBlock'
*
* Refer to M16.FOUNDATION
*
fInline    ENTRY
           jml      reserved
*
* Offset +52 will contain the Foundation stack based callback.
* Calls to this vector use the ORCA stack model where the called function
* clears the stack if the start resource flag word bit16 is clear.  Otherwise
* the APW C stack model is used, where the caller clears it's own parameters.
*
*          extern pascal lda Command, ParameterBlockPtr)
*
* Refer to FOUNDATION.H
*
fStack   ENTRY
           jml      reserved
*
* Offset +56 will contain the a pointer to the Foundation TaskMaster record.
*
           case     on
FEVENTPTR  ENTRY
fEventPtr  ENTRY
           case     off
           dc       i4'0'
*
reserved   lda      #1                  badSystemCall
           sec
           rtl
*
           case     on
FUSERID   ENTRY                         For the convienence of ORCA C & Pascal
fUserID   ENTRY                         users.  ~USERID is used by the library
~USERID    dc       i2'0'               and ~TOOLERROR is for ORCA's tool glue
~TOOLERROR dc       i2'0'               error return handler.
           case     off
*
* The following glue is for ORCA/Pascal only.
*
*
fAddPrivateData ENTRY
           ldx      #26
           jmp      ~PasGlue
fAddResource ENTRY
           ldx      #1
           jmp      ~PasGlue
fBuildLinkHand ENTRY
           ldx      #11
           jmp      ~PasGlue
fColorPalette ENTRY
           ldx      #39
           jmp      ~PasGlue
fCopyResource ENTRY
           ldx      #25
           jmp      ~PasGlue
fCountResources ENTRY
           ldx      #18
           jmp      ~PasGlue
fDetachResource ENTRY
           ldx      #5
           jmp      ~PasGlue
fDisposeLinkHand ENTRY
           ldx      #28
           jmp      ~PasGlue
fExtendLinkHand ENTRY
           ldx      #10
           jmp      ~PasGlue
fFindHostLink ENTRY
           ldx      #36
           jmp      ~PasGlue
fGetEditorStatus ENTRY
           ldx      #33
           jmp      ~PasGlue
fGetIndResource ENTRY
           ldx      #19
           jmp      ~PasGlue
fGetKernalID ENTRY
           ldx      #40
           jmp      ~PasGlue2
fGetPrivateData ENTRY
           ldx      #15
           jmp      ~PasGlue
fGetResourceAttr ENTRY
           ldx      #22
           jmp      ~PasGlue
fGetResourceName ENTRY
           ldx      #8
           jmp      ~PasGlue
fGetResourceSize ENTRY
           ldx      #20
           jmp      ~PasGlue
fGetStdTypeName ENTRY
           ldx      #7
           jmp      ~PasGlue
fGetWindowTitle ENTRY
           ldx      #29
           jmp      ~PasGlue
fLoadFileData ENTRY
           ldx      #13
           jmp      ~PasGlue
fLoadResource ENTRY
           ldx      #3
           jmp      ~PasGlue
fLoadScrap ENTRY
           ldx      #31
           jmp      ~PasGlue
fMarquee ENTRY
           ldx      #38
           jmp      ~PasGlue
fQueryLinkHand ENTRY
           ldx      #12
           jmp      ~PasGlue
fRelPrivateData ENTRY
           ldx      #27
           jmp      ~PasGlue
fReleaseResource ENTRY
           ldx      #4
           jmp      ~PasGlue
fRemoveResource ENTRY
           ldx      #2
           jmp      ~PasGlue
fRequestEdit ENTRY
           ldx      #14
           jmp      ~PasGlue
fResourceConverter ENTRY
           ldx      #24
           jmp      ~PasGlue
fSaveScrap ENTRY
           ldx      #32
           jmp      ~PasGlue
fSelectorMenu ENTRY
           ldx      #35
           jmp      ~PasGlue
fSelectorRequest ENTRY
           ldx      #34
           jmp      ~PasGlue
fSetPrivateData ENTRY
           ldx      #16
           jmp      ~PasGlue
fSetResourceAttr ENTRY
           ldx      #23
           jmp      ~PasGlue
fSetResourceID ENTRY
           ldx      #21
           jmp      ~PasGlue
fSetResourceName ENTRY
           ldx      #9
           jmp      ~PasGlue
fSpecialMagic ENTRY
           ldx      #30
           jmp      ~PasGlue
fSpinCursor ENTRY
           ldx      #37
           jmp      ~PasGlue2
fUniqueResourceID ENTRY
           ldx      #17
           jmp      ~PasGlue
fWriteResource      ENTRY
           ldx      #6

~PasGlue   lda      4,s                 Stack at call time
           sta      >~GlueParm+2
           lda      6,s                   |-----------|
           sta      >~GlueParm+4          | long Pptr |
           lda      4,s                   |-----------|
           lda      1,s                   | RTL  addr |
           sta      5,s                   |-----------|
           lda      2,s
           sta      6,s
           pla
           pla

~PasGlue2  txa
           sta      >~GlueParm
           jsl      fInline
~GlueParm  ds       6
           sta      >~TOOLERROR
           rtl
*
*****************************************************************************
           END
